//=============================================================================
// VisuStella MZ - Shop Listing Unlock
// VisuMZ_3_ShopListUnlock.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_3_ShopListUnlock = true;

var VisuMZ = VisuMZ || {};
VisuMZ.ShopListUnlock = VisuMZ.ShopListUnlock || {};
VisuMZ.ShopListUnlock.version = 1.01;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 3] [Version 1.01] [ShopListUnlock]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Shop_Listing_Unlock_VisuStella_MZ
 * @base VisuMZ_1_ItemsEquipsCore
 * @orderAfter VisuMZ_1_ItemsEquipsCore
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * This plugin allows shop listings to unlock via buying and selling items in
 * any shop. Ever wanted to make a Super Potion that unlocks after buying 10
 * regular Potions, now you can. Ever wanted to make a Monster Mana Potion
 * unlock after selling enough Slime Cores? Now you can.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Create lists of items needed to be sold or bought before an item, weapon,
 *   or piece of armor can be unlocked via notetags.
 * * Items that have not yet been unlocked but have some progress made to them
 *   can become visible in the shop listings, but are unable to be bought.
 * * When these "in-progress" items are selected, a list of the necessary items
 *   needed to be bought/sold through any shop is shown in the status window.
 * * When these requirements are fulfilled, the shop item becomes available for
 *   purchase like normal.
 * * This can be used to create tier like systems of shop progression based on
 *   what the player purchases
 * * This can also create more player interactivity by allowing certain items
 *   to become available based on what players sell back to the shop.
 * * Visible but not yet unlocked item listings in shops can have different
 *   rulings for when their visibility conditions become available via notetag.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Required Plugin List ------
 *
 * * VisuMZ_1_ItemsEquipsCore
 *
 * This plugin requires the above listed plugins to be installed inside your
 * game's Plugin Manager list in order to work. You cannot start your game with
 * this plugin enabled without the listed plugins.
 *
 * ------ Tier 3 ------
 *
 * This plugin is a Tier 3 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 *
 * ---
 * 
 * === Shop Unlock-Related Notetags ===
 * 
 * ---
 *
 * <Shop Unlock Requirements>
 *  requirement
 *  requirement
 *  requirement
 * </Shop Unlock Requirements>
 *
 * - Used for: Item, Weapon, Armor Notetags
 * - Creates a list of requirements before the listed item, weapon, or armor
 *   will appear in the shop.
 *   - These items still have to be listed normally inside of "Shop Processing"
 *     event. They just don't become available until the unlock requirements
 *     have been met.
 * - Replace 'requirement' with any of the requirement types found below.
 * 
 *     Buy Item id: quantity
 *     Buy Item name: quantity
 *     Buy Weapon id: quantity
 *     Buy Weapon name: quantity
 *     Buy Armor id: quantity
 *     Buy Armor name: quantity
 *     Buy Gold: quantity
 * 
 *     Sell Item id: quantity
 *     Sell Item name: quantity
 *     Sell Weapon id: quantity
 *     Sell Weapon name: quantity
 *     Sell Armor id: quantity
 *     Sell Armor name: quantity
 *     Sell Gold: quantity
 * 
 *   - Replace 'id' with a number representing the ID of the item, weapon, or
 *     armor that is required to be bought or sold.
 *   - Replace 'name' with the associated item, weapon, or armor's name.
 *   - Replace 'quantity' with a number representing the number of items,
 *     weapons, or armors bought or sold.
 *   - For gold, "Buy Gold" refers to the amount of gold spent when buying
 *     items of any sort. "Sell Gold" refers to the amount of gold earned after
 *     selling items of any sort.
 *   - Insert multiple lines to add more shop unlock requirements.
 * 
 *   Examples:
 * 
 *   ---
 *
 *   <Shop Unlock Requirements>
 *    Buy Item Potion: 5
 *    Buy Gold: 2000
 *   </Shop Unlock Requirements>
 * 
 *   - This makes the item with this notetag require at least 5 Potions to be
 *     bought and at least 2000 gold has to be spent inside any shop for this
 *     item to become unlocked for the player to purchase.
 * 
 *   ---
 *
 *   <Shop Unlock Requirements>
 *    Sell Item Tiger Fang: 10
 *    Sell Item Tiger Claw: 5
 *   </Shop Unlock Requirements>
 * 
 *   - This makes the item with this notetag require at least 10 Tiger Fangs
 *     and at least 5 Tiger Claws to be sold to any shop before this item
 *     becomes unlocked for the player to purchase.
 * 
 *   ---
 *
 * ---
 * 
 * <Shop Unlock Visible: Always>
 * <Shop Unlock Visible: Progress>
 * <Shop Unlock Visible: Never>
 * 
 * - Used for: Item, Weapon, Armor Notetags
 * - Requires <Shop Unlock Requirements> notetag present, too.
 * - An item, weapon, or armor with this notetag will change the shop listing
 *   unlock visibility requirements to something else.
 *   - Always - Always show unlockable items regardless of progress.
 *   - Progress - Show unlockable items as long as there is progress.
 *   - Never - Don't show items until fully unlocked.
 * - If this notetag is not used, refer to the default ruling set up in the
 *   Plugin Parameters.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Vocabulary Settings
 * ============================================================================
 *
 * These settings let you adjust the text displayed for this plugin.
 *
 * ---
 * 
 * Buy Window:
 * 
 *   Price Text:
 *   - This is the text that appears in place of the price for items that have
 *     yet to be unlocked. Text codes allowed.
 * 
 * ---
 * 
 * Status Window:
 * 
 *   Title Text:
 *   - Text that appears in the title for unlocks in progress.
 *   - Text codes allowed.
 * 
 *   Item Entries:
 * 
 *     Buy Item Format:
 *     - Text label for items that need to be bought.
 *     - %1 - Item Name.
 *     - Text codes allowed.
 * 
 *     Sell Item Format:
 *     - Text label for items that need to be sold.
 *     - %1 - Item Name.
 *     - Text codes allowed.
 * 
 *     Item Name Format:
 *     - Text format used for item names.
 *     - %1 - Item Name. %2 - Item Icon.
 *     - Text codes allowed.
 * 
 *   Gold Entries:
 * 
 *     Buy Gold Format:
 *     - Text label for gold spent on buying items.
 *     - %1 - Currency Name.
 *     - Text codes allowed.
 * 
 *     Sell Gold Format:
 *     - Text label for gold gained from selling items.
 *     - %1 - Currency Name.
 *     - Text codes allowed.
 * 
 *   Number Display Format:
 *   - Text format used for quantity required.
 *   - %1 - Current Amount. %2 - Target Amount.
 *   - Text codes allowed.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Window Settings
 * ============================================================================
 *
 * These settings let you adjust the windows displayed for this plugin. For the
 * shop status window, if you decide to display unlock requirements, the
 * contents will be automatically generated for the unlock requirements list.
 * If an entry's item name and text is too large to fit together in one line,
 * they will form multiple lines.
 *
 * ---
 * 
 * Buy Window:
 * 
 *   In-Progress Rulings:
 *   - What rulings do you want unlockable items to have?
 *     - Always - Always show unlockable items regardless of progress.
 *     - Progress - Show unlockable items as long as there is progress.
 *     - Never - Don't show items until fully unlocked.
 * 
 *   Change Price Text?:
 *   - Change the price text for items that have not been unlocked?
 * 
 *   Change BG Color?:
 *   - Change the background color of item listings that have not been
 *     unlocked.
 * 
 *     BG Color 1:
 *     BG Color 2:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 * 
 * ---
 * 
 * Status Window:
 * 
 *   Show Requirements?:
 *   - Show the requirements needed to fully unlock an item listing?
 * 
 *   Conditions Met Color:
 *   - Use text colors from the Window Skin. Does not work with #rrggbb
 * 
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Arisu
 * * Irina
 * * Olivia
 * * Yanfly
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.01: February 20, 2025
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.00 Official Release Date: November 27, 2023
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param ShopListUnlock
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Vocab:struct
 * @text Vocabulary Settings
 * @type struct<Vocab>
 * @desc These settings let you adjust the text displayed for this plugin.
 * @default {"Window_ShopBuy":"","priceText:str":"Need More!","Window_ShopStatus":"","title:str":"\\C[16]Unlock Requirements","StatusEntriesItem":"","itemBuyFmt:str":"Buy %1","itemSellFmt:str":"Sell %1","itemNameFmt:str":"%2%1","StatusEntriesGold":"","goldFromBuyFmt:str":"Spent \\I[314]%1","goldFromSellFmt:str":"Gained \\I[314]%1","numberDisplayFmt:str":"×%1/%2"}
 *
 * @param Window:struct
 * @text Window Settings
 * @type struct<Window>
 * @desc These settings let you adjust the windows displayed for this plugin.
 * @default {"Window_ShopBuy":"","showUnlistedRuling:str":"progress","changeUnlistedPrice:eval":"true","changeUnlistedBgColor:eval":"true","unlistedBgColor1:str":"15","unlistedBgColor2:str":"19","Window_ShopStatus":"","showRequirements:eval":"true","numberMetColor:str":"24"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Vocabulary Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Vocab:
 *
 * @param Window_ShopBuy
 * @text Buy Window
 *
 * @param priceText:str
 * @text Price Text
 * @parent Window_ShopBuy
 * @desc This is the text that appears in place of the price for
 * items that have yet to be unlocked. Text codes allowed.
 * @default Need More!
 *
 * @param Window_ShopStatus
 * @text Status Window
 *
 * @param title:str
 * @text Title Text
 * @parent Window_ShopStatus
 * @desc Text that appears in the title for unlocks in progress.
 * Text codes allowed.
 * @default \C[16]Unlock Requirements
 * 
 * @param StatusEntriesItem
 * @text Item Entries
 * @parent Window_ShopStatus
 *
 * @param itemBuyFmt:str
 * @text Buy Item Format
 * @parent StatusEntriesItem
 * @desc Text label for items that need to be bought.
 * %1 - Item Name. Text codes allowed.
 * @default Buy %1
 *
 * @param itemSellFmt:str
 * @text Sell Item Format
 * @parent StatusEntriesItem
 * @desc Text label for items that need to be sold.
 * %1 - Item Name. Text codes allowed.
 * @default Sell %1
 *
 * @param itemNameFmt:str
 * @text Item Name Format
 * @parent StatusEntriesItem
 * @desc Text format used for item names.
 * %1 - Item Name. %2 - Item Icon.
 * @default %2%1
 * 
 * @param StatusEntriesGold
 * @text Gold Entries
 * @parent Window_ShopStatus
 *
 * @param goldFromBuyFmt:str
 * @text Buy Gold Format
 * @parent StatusEntriesGold
 * @desc Text label for gold spent on buying items.
 * %1 - Currency Name. Text codes allowed.
 * @default Spent \I[314]%1
 *
 * @param goldFromSellFmt:str
 * @text Sell Gold Format
 * @parent StatusEntriesGold
 * @desc Text label for gold gained from selling items.
 * %1 - Currency Name. Text codes allowed.
 * @default Gained \I[314]%1
 *
 * @param numberDisplayFmt:str
 * @text Number Display Format
 * @parent Window_ShopStatus
 * @desc Text format used for quantity required.
 * %1 - Current Amount. %2 - Target Amount.
 * @default ×%1/%2
 *
 */
/* ----------------------------------------------------------------------------
 * Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Window:
 *
 * @param Window_ShopBuy
 * @text Buy Window
 *
 * @param showUnlistedRuling:str
 * @text In-Progress Rulings
 * @parent Window_ShopBuy
 * @type select
 * @option Always - Always show unlockable items regardless of progress.
 * @value always
 * @option Progress - Show unlockable items as long as there is progress.
 * @value progress
 * @option Never - Don't show items until fully unlocked.
 * @value never
 * @desc What rulings do you want unlockable items to have?
 * @default progress
 *
 * @param changeUnlistedPrice:eval
 * @text Change Price Text?
 * @parent Window_ShopBuy
 * @type boolean
 * @on Change Text
 * @off Show Price
 * @desc Change the price text for items that have not been unlocked?
 * @default true
 *
 * @param changeUnlistedBgColor:eval
 * @text Change BG Color?
 * @parent Window_ShopBuy
 * @type boolean
 * @on Change Color
 * @off Don't Change
 * @desc Change the background color of item listings that have not been unlocked.
 * @default true
 *
 * @param unlistedBgColor1:str
 * @text BG Color 1
 * @parent changeUnlistedBgColor:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 15
 *
 * @param unlistedBgColor2:str
 * @text BG Color 2
 * @parent changeUnlistedBgColor:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 19
 *
 * @param Window_ShopStatus
 * @text Status Window
 *
 * @param showRequirements:eval
 * @text Show Requirements?
 * @parent Window_ShopStatus
 * @type boolean
 * @on Show Requirements
 * @off Show Item Data
 * @desc Show the requirements needed to fully unlock an item listing?
 * @default true
 *
 * @param numberMetColor:str
 * @text Conditions Met Color
 * @parent Window_ShopStatus
 * @desc Use text colors from the Window Skin.
 * Does not work with #rrggbb
 * @default 24
 *
 */
//=============================================================================

const _0x1a5c44=_0x1875;(function(_0x4bf660,_0x5b9812){const _0x3d7a08=_0x1875,_0x224b36=_0x4bf660();while(!![]){try{const _0x2c0858=-parseInt(_0x3d7a08(0x12e))/0x1+-parseInt(_0x3d7a08(0x15c))/0x2+parseInt(_0x3d7a08(0x144))/0x3+-parseInt(_0x3d7a08(0x185))/0x4*(-parseInt(_0x3d7a08(0x168))/0x5)+-parseInt(_0x3d7a08(0x11f))/0x6*(parseInt(_0x3d7a08(0x160))/0x7)+parseInt(_0x3d7a08(0xf6))/0x8*(-parseInt(_0x3d7a08(0x154))/0x9)+parseInt(_0x3d7a08(0x12a))/0xa*(parseInt(_0x3d7a08(0x148))/0xb);if(_0x2c0858===_0x5b9812)break;else _0x224b36['push'](_0x224b36['shift']());}catch(_0x10cf80){_0x224b36['push'](_0x224b36['shift']());}}}(_0x18d7,0xde5a1));var label=_0x1a5c44(0x107),tier=tier||0x0,dependencies=['VisuMZ_1_ItemsEquipsCore'],pluginData=$plugins[_0x1a5c44(0x156)](function(_0x673296){const _0x3358b7=_0x1a5c44;return _0x673296[_0x3358b7(0x17d)]&&_0x673296[_0x3358b7(0x16c)][_0x3358b7(0x149)]('['+label+']');})[0x0];function _0x18d7(){const _0x2a26e6=['hasShopListingNotetag','setItem','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','getItemIdWithName','innerWidth','Vocab','shouldDrawShopUnlockList','drawItemBackground','prototype','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','17382gtHGUa','lineHeight','note','_item','test','itemSellFmt','Window_ShopBuy_drawItemCost','innerHeight','toUpperCase','remove','clear','6920RKaSCu','unlistedBgColor1','item-%1','map','1730456nqAMYX','max','Window_ShopBuy_isEnabled','call','parameters','never','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','ItemsEquipsCore','changeUnlistedPrice','drawShopListingUnlockList','textSizeEx','isShopListingUnlockShown','isEnabled','sell','\x5cI[%1]','Need\x20More!','getShopTrackingItemSell','buy','push','drawItemDarkRect','%2%1','Window_ShopStatus_setItem','5414610IfZoWi','progress','NUM','isArmor','81301HoJVeb','includes','getShopTrackingItemBuy','split','setShopListingUnlockItem','title','isItem','return\x200','isShopListingAnyProgress','ARRAYEVAL','drawItemBackgroundUnlisted','toLowerCase','702Qsowee','ARRAYNUM','filter','armor-%1','constructor','isShopListingUnlockRulingType','parse','isShopListingUnlocked','2903296lfvVdI','numberMetColor','left','name','3493kdwQyP','meetsShopListingUnlockRequirements','UnlockRuling','STR','priceText','getShopTrackingItem','getShopTrackingGoldBuy','gold','25ulyptv','getColor','currencyUnit','Spent\x20\x5cI[314]%1','description','itemDataFontSize','ShopUnlock','getShopTrackingGoldSell','getWeaponIdWithName','exit','strokeRect','Window_ShopBuy_goodsToItem','gradientFillRect','showUnlistedRuling','goldFromSellFmt','ARRAYFUNC','ARRAYJSON','ConvertParams','isWeapon','weapon-%1','RegExp','status','numberDisplayFmt','\x5cC[%1]%2\x5cC[0]','SHOP_LIST_UNLOCK','Window_Selectable_drawItemBackground','FUNC','contentsBack','drawShopListingUnlockTitle','246112ImNPqe','173192gTaGeV','Settings','itemAt','version','STRUCT','goodsToItem','shouldChangeUnlistedItemBackground','getArmorIdWithName','drawItemKeyData','format','Sell\x20%1','itemBuyFmt','unlistedBgColor2','always','Buy\x20%1','showRequirements','EVAL','ShopListUnlock','goldFromBuyFmt','match','_isShopListingUnlocked','drawItemCostShopListingUnlock','itemNameFmt','in\x20order\x20for\x20VisuMZ_3_ShopListUnlock\x20to\x20work.','drawTextEx','drawShopListingUnlockRemaining','Window','changeUnlistedBgColor','trim','right','width'];_0x18d7=function(){return _0x2a26e6;};return _0x18d7();}function _0x1875(_0x53b112,_0x1e6906){const _0x18d7f2=_0x18d7();return _0x1875=function(_0x187568,_0x2e3101){_0x187568=_0x187568-0xf6;let _0x3e9893=_0x18d7f2[_0x187568];return _0x3e9893;},_0x1875(_0x53b112,_0x1e6906);}VisuMZ[label][_0x1a5c44(0xf7)]=VisuMZ[label]['Settings']||{},VisuMZ['ConvertParams']=function(_0x570cac,_0x36c2e8){const _0x1996ef=_0x1a5c44;for(const _0x130d10 in _0x36c2e8){if(_0x130d10[_0x1996ef(0x109)](/(.*):(.*)/i)){const _0x195076=String(RegExp['$1']),_0x63bd74=String(RegExp['$2'])[_0x1996ef(0x127)]()[_0x1996ef(0x112)]();let _0x2e796b,_0x2a5c5d,_0x612980;switch(_0x63bd74){case _0x1996ef(0x146):_0x2e796b=_0x36c2e8[_0x130d10]!==''?Number(_0x36c2e8[_0x130d10]):0x0;break;case _0x1996ef(0x155):_0x2a5c5d=_0x36c2e8[_0x130d10]!==''?JSON['parse'](_0x36c2e8[_0x130d10]):[],_0x2e796b=_0x2a5c5d[_0x1996ef(0x12d)](_0x2d5fd1=>Number(_0x2d5fd1));break;case _0x1996ef(0x106):_0x2e796b=_0x36c2e8[_0x130d10]!==''?eval(_0x36c2e8[_0x130d10]):null;break;case _0x1996ef(0x151):_0x2a5c5d=_0x36c2e8[_0x130d10]!==''?JSON[_0x1996ef(0x15a)](_0x36c2e8[_0x130d10]):[],_0x2e796b=_0x2a5c5d[_0x1996ef(0x12d)](_0x90e3ac=>eval(_0x90e3ac));break;case'JSON':_0x2e796b=_0x36c2e8[_0x130d10]!==''?JSON[_0x1996ef(0x15a)](_0x36c2e8[_0x130d10]):'';break;case _0x1996ef(0x178):_0x2a5c5d=_0x36c2e8[_0x130d10]!==''?JSON[_0x1996ef(0x15a)](_0x36c2e8[_0x130d10]):[],_0x2e796b=_0x2a5c5d['map'](_0x53f77e=>JSON[_0x1996ef(0x15a)](_0x53f77e));break;case _0x1996ef(0x182):_0x2e796b=_0x36c2e8[_0x130d10]!==''?new Function(JSON[_0x1996ef(0x15a)](_0x36c2e8[_0x130d10])):new Function(_0x1996ef(0x14f));break;case _0x1996ef(0x177):_0x2a5c5d=_0x36c2e8[_0x130d10]!==''?JSON['parse'](_0x36c2e8[_0x130d10]):[],_0x2e796b=_0x2a5c5d[_0x1996ef(0x12d)](_0x52019=>new Function(JSON[_0x1996ef(0x15a)](_0x52019)));break;case _0x1996ef(0x163):_0x2e796b=_0x36c2e8[_0x130d10]!==''?String(_0x36c2e8[_0x130d10]):'';break;case'ARRAYSTR':_0x2a5c5d=_0x36c2e8[_0x130d10]!==''?JSON[_0x1996ef(0x15a)](_0x36c2e8[_0x130d10]):[],_0x2e796b=_0x2a5c5d['map'](_0x6cea6c=>String(_0x6cea6c));break;case _0x1996ef(0xfa):_0x612980=_0x36c2e8[_0x130d10]!==''?JSON[_0x1996ef(0x15a)](_0x36c2e8[_0x130d10]):{},_0x2e796b=VisuMZ[_0x1996ef(0x179)]({},_0x612980);break;case'ARRAYSTRUCT':_0x2a5c5d=_0x36c2e8[_0x130d10]!==''?JSON[_0x1996ef(0x15a)](_0x36c2e8[_0x130d10]):[],_0x2e796b=_0x2a5c5d[_0x1996ef(0x12d)](_0xec1c0c=>VisuMZ[_0x1996ef(0x179)]({},JSON['parse'](_0xec1c0c)));break;default:continue;}_0x570cac[_0x195076]=_0x2e796b;}}return _0x570cac;},(_0x4577d3=>{const _0x1776dc=_0x1a5c44,_0x14d5a4=_0x4577d3[_0x1776dc(0x15f)];for(const _0x551caf of dependencies){if(!Imported[_0x551caf]){alert(_0x1776dc(0x117)['format'](_0x14d5a4,_0x551caf)),SceneManager['exit']();break;}}const _0x3c8e62=_0x4577d3['description'];if(_0x3c8e62[_0x1776dc(0x109)](/\[Version[ ](.*?)\]/i)){const _0x592698=Number(RegExp['$1']);_0x592698!==VisuMZ[label][_0x1776dc(0xf9)]&&(alert(_0x1776dc(0x11e)[_0x1776dc(0xff)](_0x14d5a4,_0x592698)),SceneManager[_0x1776dc(0x171)]());}if(_0x3c8e62[_0x1776dc(0x109)](/\[Tier[ ](\d+)\]/i)){const _0x1f6a3b=Number(RegExp['$1']);_0x1f6a3b<tier?(alert(_0x1776dc(0x134)[_0x1776dc(0xff)](_0x14d5a4,_0x1f6a3b,tier)),SceneManager[_0x1776dc(0x171)]()):tier=Math[_0x1776dc(0x12f)](_0x1f6a3b,tier);}VisuMZ[_0x1776dc(0x179)](VisuMZ[label][_0x1776dc(0xf7)],_0x4577d3[_0x1776dc(0x132)]);})(pluginData);if(VisuMZ[_0x1a5c44(0x135)]['version']<1.47){let text='';text+='VisuMZ_1_ItemsEquipsCore\x20needs\x20to\x20be\x20updated\x20',text+=_0x1a5c44(0x10d),alert(text),SceneManager['exit']();}VisuMZ[_0x1a5c44(0x107)]['RegExp']={'ShopUnlock':/<SHOP UNLOCK REQUIREMENT(?:|S)>\s*([\s\S]*)\s*<\/SHOP UNLOCK REQUIREMENT(?:|S)>/i,'UnlockRuling':/<SHOP UNLOCK (?:RULE|RULING|VISIBLE):[ ](.*)>/i},DataManager[_0x1a5c44(0x15b)]=function(_0x4e23e6){const _0x1471bd=_0x1a5c44;let _0x45b247='';if(DataManager[_0x1471bd(0x14e)](_0x4e23e6))_0x45b247=_0x1471bd(0x12c)[_0x1471bd(0xff)](_0x4e23e6['id']);else{if(DataManager[_0x1471bd(0x17a)](_0x4e23e6))_0x45b247=_0x1471bd(0x17b)['format'](_0x4e23e6['id']);else{if(DataManager[_0x1471bd(0x147)](_0x4e23e6))_0x45b247=_0x1471bd(0x157)['format'](_0x4e23e6['id']);else return![];}}this[_0x1471bd(0x10a)]=this[_0x1471bd(0x10a)]||[];if(this['_isShopListingUnlocked'][_0x1471bd(0x149)](_0x45b247))return!![];return this[_0x1471bd(0x115)](_0x4e23e6)?this[_0x1471bd(0x161)](_0x4e23e6)&&this[_0x1471bd(0x10a)][_0x1471bd(0x140)](_0x45b247):this[_0x1471bd(0x10a)][_0x1471bd(0x140)](_0x45b247),this[_0x1471bd(0x10a)][_0x1471bd(0x149)](_0x45b247);},DataManager[_0x1a5c44(0x115)]=function(_0x4b669d){const _0x2bcd46=_0x1a5c44,_0x48097c=VisuMZ[_0x2bcd46(0x107)][_0x2bcd46(0x17c)],_0x1d53d6=_0x4b669d[_0x2bcd46(0x121)]||'';if(_0x1d53d6[_0x2bcd46(0x109)](_0x48097c['ShopUnlock']))return!![];return![];},DataManager[_0x1a5c44(0x161)]=function(_0x401b62){const _0x17c8ed=_0x1a5c44,_0x38a2ad=VisuMZ[_0x17c8ed(0x107)][_0x17c8ed(0x17c)],_0x52f6c6=_0x401b62['note']||'';if(_0x52f6c6[_0x17c8ed(0x109)](_0x38a2ad[_0x17c8ed(0x16e)])){const _0x1e1430=String(RegExp['$1'])['split'](/[\r\n]+/)['remove']('');for(const _0x4eac55 of _0x1e1430){if(_0x4eac55[_0x17c8ed(0x109)](/(?:BUY|BOUGHT|SPENT|SPEND) GOLD:[ ](\d+)/i)){const _0x54bebd=Number(RegExp['$1']);if($gameParty[_0x17c8ed(0x166)]()<_0x54bebd)return![];}if(_0x4eac55[_0x17c8ed(0x109)](/(?:SELL|SOLD|EARN|EARNED|GAIN|GAINED) GOLD:[ ](\d+)/i)){const _0x4b35e7=Number(RegExp['$1']);if($gameParty['getShopTrackingGoldSell']()<_0x4b35e7)return![];}if(_0x4eac55[_0x17c8ed(0x109)](/(?:BUY|BOUGHT) ITEM[ ](.*):[ ](\d+)/i)){const _0x172d6a=String(RegExp['$1']),_0x30c3b2=Number(RegExp['$2']),_0x49dbd7=/^\d+$/['test'](_0x172d6a),_0x15c72d=_0x49dbd7?Number(_0x172d6a):this[_0x17c8ed(0x118)](_0x172d6a),_0x295427=$dataItems[_0x15c72d];if($gameParty[_0x17c8ed(0x14a)](_0x295427)<_0x30c3b2)return![];}if(_0x4eac55['match'](/(?:SELL|SOLD) ITEM[ ](.*):[ ](\d+)/i)){const _0x50ae4f=String(RegExp['$1']),_0x730904=Number(RegExp['$2']),_0x3b2f9c=/^\d+$/[_0x17c8ed(0x123)](_0x50ae4f),_0x50e1ef=_0x3b2f9c?Number(_0x50ae4f):this[_0x17c8ed(0x118)](_0x50ae4f),_0x27d238=$dataItems[_0x50e1ef];if($gameParty['getShopTrackingItemSell'](_0x27d238)<_0x730904)return![];}if(_0x4eac55[_0x17c8ed(0x109)](/(?:BUY|BOUGHT) WEAPON[ ](.*):[ ](\d+)/i)){const _0x706c84=String(RegExp['$1']),_0x3acacc=Number(RegExp['$2']),_0x1d9d1f=/^\d+$/['test'](_0x706c84),_0x5f5355=_0x1d9d1f?Number(_0x706c84):this[_0x17c8ed(0x170)](_0x706c84),_0x2e04b1=$dataWeapons[_0x5f5355];if($gameParty[_0x17c8ed(0x14a)](_0x2e04b1)<_0x3acacc)return![];}if(_0x4eac55[_0x17c8ed(0x109)](/(?:SELL|SOLD) WEAPON[ ](.*):[ ](\d+)/i)){const _0x517493=String(RegExp['$1']),_0x5abeb3=Number(RegExp['$2']),_0x4188cc=/^\d+$/[_0x17c8ed(0x123)](_0x517493),_0x2a89c0=_0x4188cc?Number(_0x517493):this['getWeaponIdWithName'](_0x517493),_0x276ffe=$dataWeapons[_0x2a89c0];if($gameParty[_0x17c8ed(0x13e)](_0x276ffe)<_0x5abeb3)return![];}if(_0x4eac55[_0x17c8ed(0x109)](/(?:BUY|BOUGHT) ARMOR[ ](.*):[ ](\d+)/i)){const _0x51c09c=String(RegExp['$1']),_0xefaa84=Number(RegExp['$2']),_0x5a651a=/^\d+$/[_0x17c8ed(0x123)](_0x51c09c),_0x8be68f=_0x5a651a?Number(_0x51c09c):this[_0x17c8ed(0xfd)](_0x51c09c),_0x1292ea=$dataArmors[_0x8be68f];if($gameParty['getShopTrackingItemBuy'](_0x1292ea)<_0xefaa84)return![];}if(_0x4eac55['match'](/(?:SELL|SOLD) ARMOR[ ](.*):[ ](\d+)/i)){const _0x5e7a7d=String(RegExp['$1']),_0x427f1e=Number(RegExp['$2']),_0x290547=/^\d+$/[_0x17c8ed(0x123)](_0x5e7a7d),_0x572e26=_0x290547?Number(_0x5e7a7d):this[_0x17c8ed(0xfd)](_0x5e7a7d),_0x4cce47=$dataArmors[_0x572e26];if($gameParty[_0x17c8ed(0x13e)](_0x4cce47)<_0x427f1e)return![];}}}return!![];},DataManager[_0x1a5c44(0x139)]=function(_0x47d01f){const _0x407220=_0x1a5c44,_0x39a8bd=this[_0x407220(0x159)](_0x47d01f);if(_0x39a8bd===_0x407220(0x103))return!![];else{if(_0x39a8bd===_0x407220(0x133))return![];else{if(_0x39a8bd===_0x407220(0x145))return DataManager['isShopListingAnyProgress'](_0x47d01f);}}return![];},DataManager['isShopListingUnlockRulingType']=function(_0x30f0cc){const _0xd91cd8=_0x1a5c44,_0x222722=VisuMZ[_0xd91cd8(0x107)]['RegExp'],_0x2ae69a=_0x30f0cc[_0xd91cd8(0x121)]||'';if(_0x2ae69a['match'](_0x222722[_0xd91cd8(0x162)])){const _0x21cabb=String(RegExp['$1'])[_0xd91cd8(0x153)]()['trim']();if([_0xd91cd8(0x103),_0xd91cd8(0x133),_0xd91cd8(0x145)][_0xd91cd8(0x149)](_0x21cabb))return _0x21cabb;}return Window_ShopBuy['SHOP_LIST_UNLOCK'][_0xd91cd8(0x175)];},DataManager[_0x1a5c44(0x150)]=function(_0xb541f4){const _0x458e8c=_0x1a5c44,_0x3d6d42=VisuMZ[_0x458e8c(0x107)][_0x458e8c(0x17c)],_0x309b0b=_0xb541f4[_0x458e8c(0x121)]||'';if(_0x309b0b[_0x458e8c(0x109)](_0x3d6d42['ShopUnlock'])){const _0x12dfc1=String(RegExp['$1'])[_0x458e8c(0x14b)](/[\r\n]+/)[_0x458e8c(0x128)]('');for(const _0x4b42ed of _0x12dfc1){if(_0x4b42ed[_0x458e8c(0x109)](/(?:BUY|BOUGHT|SPENT|SPEND) GOLD:[ ](\d+)/i)){if($gameParty[_0x458e8c(0x166)]()>=0x1)return!![];}if(_0x4b42ed[_0x458e8c(0x109)](/(?:SELL|SOLD|EARN|EARNED|GAIN|GAINED) GOLD:[ ](\d+)/i)){if($gameParty[_0x458e8c(0x16f)]()>=0x1)return!![];}if(_0x4b42ed[_0x458e8c(0x109)](/(?:BUY|BOUGHT) ITEM[ ](.*):[ ](\d+)/i)){const _0x433ac4=String(RegExp['$1']),_0x489eed=/^\d+$/[_0x458e8c(0x123)](_0x433ac4),_0x1816c4=_0x489eed?Number(_0x433ac4):this[_0x458e8c(0x118)](_0x433ac4),_0x162782=$dataItems[_0x1816c4];if($gameParty[_0x458e8c(0x14a)](_0x162782)>=0x1)return!![];}if(_0x4b42ed['match'](/(?:SELL|SOLD) ITEM[ ](.*):[ ](\d+)/i)){const _0x5be362=String(RegExp['$1']),_0x4ccbab=/^\d+$/[_0x458e8c(0x123)](_0x5be362),_0x12cedf=_0x4ccbab?Number(_0x5be362):this[_0x458e8c(0x118)](_0x5be362),_0x59ae80=$dataItems[_0x12cedf];if($gameParty['getShopTrackingItemSell'](_0x59ae80)>=0x1)return!![];}if(_0x4b42ed[_0x458e8c(0x109)](/(?:BUY|BOUGHT) WEAPON[ ](.*):[ ](\d+)/i)){const _0x20d345=String(RegExp['$1']),_0x35b216=/^\d+$/['test'](_0x20d345),_0xc5b3cf=_0x35b216?Number(_0x20d345):this[_0x458e8c(0x170)](_0x20d345),_0x4e38c3=$dataWeapons[_0xc5b3cf];if($gameParty[_0x458e8c(0x14a)](_0x4e38c3)>=0x1)return!![];}if(_0x4b42ed[_0x458e8c(0x109)](/(?:SELL|SOLD) WEAPON[ ](.*):[ ](\d+)/i)){const _0x6f3b73=String(RegExp['$1']),_0x144073=/^\d+$/[_0x458e8c(0x123)](_0x6f3b73),_0x35a421=_0x144073?Number(_0x6f3b73):this['getWeaponIdWithName'](_0x6f3b73),_0x12b307=$dataWeapons[_0x35a421];if($gameParty[_0x458e8c(0x13e)](_0x12b307)>=0x1)return!![];}if(_0x4b42ed[_0x458e8c(0x109)](/(?:BUY|BOUGHT) ARMOR[ ](.*):[ ](\d+)/i)){const _0x2ce151=String(RegExp['$1']),_0x187ee7=/^\d+$/[_0x458e8c(0x123)](_0x2ce151),_0x5c22e3=_0x187ee7?Number(_0x2ce151):this[_0x458e8c(0xfd)](_0x2ce151),_0x103320=$dataArmors[_0x5c22e3];if($gameParty[_0x458e8c(0x14a)](_0x103320)>=0x1)return!![];}if(_0x4b42ed[_0x458e8c(0x109)](/(?:SELL|SOLD) ARMOR[ ](.*):[ ](\d+)/i)){const _0x3d30dc=String(RegExp['$1']),_0x3b1048=/^\d+$/[_0x458e8c(0x123)](_0x3d30dc),_0x55a62d=_0x3b1048?Number(_0x3d30dc):this['getArmorIdWithName'](_0x3d30dc),_0x19fa71=$dataArmors[_0x55a62d];if($gameParty[_0x458e8c(0x13e)](_0x19fa71)>=0x1)return!![];}}}return![];},TextManager[_0x1a5c44(0x180)]={'priceText':VisuMZ[_0x1a5c44(0x107)]['Settings'][_0x1a5c44(0x11a)][_0x1a5c44(0x164)]??_0x1a5c44(0x13d),'title':VisuMZ[_0x1a5c44(0x107)][_0x1a5c44(0xf7)][_0x1a5c44(0x11a)]['title']??'\x5cC[16]Unlock\x20Requirements','itemBuyFmt':VisuMZ[_0x1a5c44(0x107)][_0x1a5c44(0xf7)]['Vocab'][_0x1a5c44(0x101)]??_0x1a5c44(0x104),'itemSellFmt':VisuMZ[_0x1a5c44(0x107)][_0x1a5c44(0xf7)][_0x1a5c44(0x11a)]['itemSellFmt']??_0x1a5c44(0x100),'itemNameFmt':VisuMZ[_0x1a5c44(0x107)][_0x1a5c44(0xf7)][_0x1a5c44(0x11a)][_0x1a5c44(0x10c)]??_0x1a5c44(0x142),'goldFromBuyFmt':VisuMZ['ShopListUnlock'][_0x1a5c44(0xf7)][_0x1a5c44(0x11a)][_0x1a5c44(0x108)]??_0x1a5c44(0x16b),'goldFromSellFmt':VisuMZ['ShopListUnlock'][_0x1a5c44(0xf7)][_0x1a5c44(0x11a)]['goldFromSellFmt']??'Gained\x20\x5cI[314]%1','numberDisplayFmt':VisuMZ[_0x1a5c44(0x107)][_0x1a5c44(0xf7)][_0x1a5c44(0x11a)][_0x1a5c44(0x17e)]??'×%1/%2'},Window_ShopBuy[_0x1a5c44(0x180)]={'showUnlistedRuling':VisuMZ['ShopListUnlock'][_0x1a5c44(0xf7)][_0x1a5c44(0x110)][_0x1a5c44(0x175)]??_0x1a5c44(0x145),'changeUnlistedPrice':VisuMZ['ShopListUnlock']['Settings'][_0x1a5c44(0x110)]['changeUnlistedPrice']??!![],'changeUnlistedBgColor':VisuMZ[_0x1a5c44(0x107)][_0x1a5c44(0xf7)][_0x1a5c44(0x110)][_0x1a5c44(0x111)]??!![],'unlistedBgColor1':VisuMZ['ShopListUnlock'][_0x1a5c44(0xf7)][_0x1a5c44(0x110)][_0x1a5c44(0x12b)]??0xf,'unlistedBgColor2':VisuMZ[_0x1a5c44(0x107)][_0x1a5c44(0xf7)][_0x1a5c44(0x110)][_0x1a5c44(0x102)]??0x13},VisuMZ[_0x1a5c44(0x107)][_0x1a5c44(0x173)]=Window_ShopBuy[_0x1a5c44(0x11d)][_0x1a5c44(0xfb)],Window_ShopBuy[_0x1a5c44(0x11d)]['goodsToItem']=function(_0x2535c1){const _0x41c7d3=_0x1a5c44;let _0x3515f1=VisuMZ[_0x41c7d3(0x107)]['Window_ShopBuy_goodsToItem']['call'](this,_0x2535c1);if(!_0x3515f1)return null;if(DataManager['isShopListingUnlocked'](_0x3515f1))return _0x3515f1;else{if(DataManager['isShopListingUnlockShown'](_0x3515f1))return _0x3515f1;}return null;},VisuMZ['ShopListUnlock'][_0x1a5c44(0x130)]=Window_ShopBuy[_0x1a5c44(0x11d)][_0x1a5c44(0x13a)],Window_ShopBuy['prototype'][_0x1a5c44(0x13a)]=function(_0xb7dcbf){const _0x116f08=_0x1a5c44;if(_0xb7dcbf&&!DataManager[_0x116f08(0x15b)](_0xb7dcbf))return![];return VisuMZ[_0x116f08(0x107)][_0x116f08(0x130)][_0x116f08(0x131)](this,_0xb7dcbf);},VisuMZ['ShopListUnlock'][_0x1a5c44(0x125)]=Window_ShopBuy[_0x1a5c44(0x11d)]['drawItemCost'],Window_ShopBuy['prototype']['drawItemCost']=function(_0x28d4d4,_0x3eef57){const _0x369460=_0x1a5c44;_0x28d4d4&&!DataManager[_0x369460(0x15b)](_0x28d4d4)&&Window_ShopBuy[_0x369460(0x180)][_0x369460(0x136)]?this[_0x369460(0x10b)](_0x3eef57):VisuMZ['ShopListUnlock'][_0x369460(0x125)][_0x369460(0x131)](this,_0x28d4d4,_0x3eef57);},VisuMZ[_0x1a5c44(0x107)]['Window_Selectable_drawItemBackground']=Window_Selectable[_0x1a5c44(0x11d)][_0x1a5c44(0x11c)],Window_Selectable[_0x1a5c44(0x11d)][_0x1a5c44(0x11c)]=function(_0x303e40){const _0x17ed99=_0x1a5c44;this[_0x17ed99(0x158)]===Window_ShopBuy&&this[_0x17ed99(0xfc)](_0x303e40)?this[_0x17ed99(0x152)](_0x303e40):VisuMZ[_0x17ed99(0x107)][_0x17ed99(0x181)][_0x17ed99(0x131)](this,_0x303e40);},Window_ShopBuy['prototype'][_0x1a5c44(0xfc)]=function(_0x219416){const _0x240351=_0x1a5c44;if(!Window_ShopBuy['SHOP_LIST_UNLOCK'][_0x240351(0x111)])return![];const _0x2f575e=this[_0x240351(0xf8)](_0x219416);if(!_0x2f575e)return![];if(DataManager[_0x240351(0x15b)](_0x2f575e))return![];return!![];},Window_ShopBuy[_0x1a5c44(0x11d)][_0x1a5c44(0x152)]=function(_0x19193d){const _0x550c6e=_0x1a5c44,_0x3210ef=Window_ShopBuy[_0x550c6e(0x180)],_0x534c16=ColorManager[_0x550c6e(0x169)](_0x3210ef[_0x550c6e(0x12b)]),_0x537815=ColorManager[_0x550c6e(0x169)](_0x3210ef[_0x550c6e(0x102)]),_0x30651f=this['itemRect'](_0x19193d),_0xa4ad41=_0x30651f['x'],_0x5b532f=_0x30651f['y'],_0x2cea54=_0x30651f[_0x550c6e(0x114)],_0x4c8705=_0x30651f['height'];this['contentsBack'][_0x550c6e(0x174)](_0xa4ad41,_0x5b532f,_0x2cea54,_0x4c8705,_0x534c16,_0x537815,!![]),this[_0x550c6e(0x183)][_0x550c6e(0x172)](_0xa4ad41,_0x5b532f,_0x2cea54,_0x4c8705,_0x534c16);},Window_ShopBuy[_0x1a5c44(0x11d)][_0x1a5c44(0x10b)]=function(_0x182e44){const _0x5363e6=_0x1a5c44,_0x2cf477=TextManager[_0x5363e6(0x180)][_0x5363e6(0x164)]['trim'](),_0x3ebcc9=this[_0x5363e6(0x138)](_0x2cf477)[_0x5363e6(0x114)],_0x5508cb=_0x182e44[_0x5363e6(0x114)]-_0x3ebcc9;this['drawTextEx'](_0x2cf477,_0x5508cb,_0x182e44['y']);},Window_ShopStatus[_0x1a5c44(0x180)]={'showRequirements':VisuMZ[_0x1a5c44(0x107)][_0x1a5c44(0xf7)][_0x1a5c44(0x110)]['showRequirements']??!![],'numberMetColor':VisuMZ[_0x1a5c44(0x107)][_0x1a5c44(0xf7)]['Window']['numberMetColor']??0x18},VisuMZ[_0x1a5c44(0x107)][_0x1a5c44(0x143)]=Window_ShopStatus[_0x1a5c44(0x11d)][_0x1a5c44(0x116)],Window_ShopStatus[_0x1a5c44(0x11d)][_0x1a5c44(0x116)]=function(_0xaa8ffd){const _0x5e787e=_0x1a5c44;this[_0x5e787e(0x11b)](_0xaa8ffd)?this[_0x5e787e(0x14c)](_0xaa8ffd):VisuMZ[_0x5e787e(0x107)][_0x5e787e(0x143)][_0x5e787e(0x131)](this,_0xaa8ffd);},Window_ShopStatus['prototype']['shouldDrawShopUnlockList']=function(_0x5d1d1e){const _0xabb78=_0x1a5c44;if(!_0x5d1d1e)return![];if(!Window_ShopStatus[_0xabb78(0x180)][_0xabb78(0x105)])return![];if(DataManager['isShopListingUnlocked'](_0x5d1d1e))return![];if(DataManager[_0xabb78(0x161)](_0x5d1d1e))return![];return!![];},Window_ShopStatus['prototype'][_0x1a5c44(0x14c)]=function(_0x4d7abc){const _0x11e30a=_0x1a5c44;this[_0x11e30a(0x122)]=_0x4d7abc,this['contents'][_0x11e30a(0x129)](),this['contentsBack'][_0x11e30a(0x129)](),this['drawShopListingUnlockRequirements'](_0x4d7abc);},Window_ShopStatus[_0x1a5c44(0x11d)]['drawShopListingUnlockRequirements']=function(_0x5f4a63){const _0x3c8fa9=_0x1a5c44;let _0x4f6b95=this['drawShopListingUnlockTitle']();_0x4f6b95=this[_0x3c8fa9(0x137)](_0x4f6b95,_0x5f4a63),this[_0x3c8fa9(0x10f)](_0x4f6b95);},Window_ShopStatus['prototype'][_0x1a5c44(0x184)]=function(){const _0x34265d=_0x1a5c44,_0x119dc8=TextManager[_0x34265d(0x180)][_0x34265d(0x14d)]||'',_0x58985c=this[_0x34265d(0x138)](_0x119dc8)[_0x34265d(0x114)],_0xeec82a=Math['floor']((this[_0x34265d(0x119)]-_0x58985c)/0x2);return this[_0x34265d(0x10e)](_0x119dc8,_0xeec82a,0x0),this[_0x34265d(0x141)](0x0,0x0,this[_0x34265d(0x119)],this['lineHeight'](),0x1),this['lineHeight']();},Window_ShopStatus['prototype'][_0x1a5c44(0x137)]=function(_0x183ef8,_0xa3237d){const _0x360c97=_0x1a5c44,_0x5f714d=VisuMZ[_0x360c97(0x107)][_0x360c97(0x17c)],_0x22b6b0=_0xa3237d[_0x360c97(0x121)]||'';if(_0x22b6b0[_0x360c97(0x109)](_0x5f714d['ShopUnlock'])){const _0x2c1bff=String(RegExp['$1'])[_0x360c97(0x14b)](/[\r\n]+/)[_0x360c97(0x128)]('');for(const _0x4c9af2 of _0x2c1bff){_0x183ef8=this['drawShopListingUnlockLine'](_0x183ef8,_0x4c9af2);}}return _0x183ef8;},Window_ShopStatus['prototype']['drawShopListingUnlockLine']=function(_0x4a7dcd,_0x2b9307){const _0x35fdd2=_0x1a5c44,_0x2bfce1=TextManager['SHOP_LIST_UNLOCK'];let _0x4e9d3c='',_0x4e9703='',_0x4f88ab='',_0x3b9c1a='',_0x1c2c44='buy',_0x39dd08=null;_0x2b9307[_0x35fdd2(0x109)](/(?:BUY|BOUGHT|SPENT|SPEND) GOLD:[ ](\d+)/i)&&(_0x4e9d3c=Number(RegExp['$1']),_0x4e9703=$gameParty[_0x35fdd2(0x166)](),_0x39dd08='gold',_0x1c2c44='buy');_0x2b9307['match'](/(?:SELL|SOLD|EARN|EARNED|GAIN|GAINED) GOLD:[ ](\d+)/i)&&(_0x4e9d3c=Number(RegExp['$1']),_0x4e9703=$gameParty['getShopTrackingGoldSell'](),_0x39dd08=_0x35fdd2(0x167),_0x1c2c44=_0x35fdd2(0x13b));if(_0x2b9307[_0x35fdd2(0x109)](/(?:BUY|BOUGHT) ITEM[ ](.*):[ ](\d+)/i)){const _0x46a9f1=String(RegExp['$1']);_0x4e9d3c=Number(RegExp['$2']);const _0x16e703=/^\d+$/[_0x35fdd2(0x123)](_0x46a9f1),_0x50776c=_0x16e703?Number(_0x46a9f1):DataManager['getItemIdWithName'](_0x46a9f1);_0x39dd08=$dataItems[_0x50776c],_0x1c2c44=_0x35fdd2(0x13f);}if(_0x2b9307[_0x35fdd2(0x109)](/(?:SELL|SOLD) ITEM[ ](.*):[ ](\d+)/i)){const _0x332a1b=String(RegExp['$1']);_0x4e9d3c=Number(RegExp['$2']);const _0x4f1c7c=/^\d+$/[_0x35fdd2(0x123)](_0x332a1b),_0x3195ff=_0x4f1c7c?Number(_0x332a1b):DataManager[_0x35fdd2(0x118)](_0x332a1b);_0x39dd08=$dataItems[_0x3195ff],_0x1c2c44=_0x35fdd2(0x13b);}if(_0x2b9307[_0x35fdd2(0x109)](/(?:BUY|BOUGHT) WEAPON[ ](.*):[ ](\d+)/i)){const _0x5e5bbe=String(RegExp['$1']);_0x4e9d3c=Number(RegExp['$2']);const _0x55a08d=/^\d+$/[_0x35fdd2(0x123)](_0x5e5bbe),_0x3d379d=_0x55a08d?Number(_0x5e5bbe):DataManager[_0x35fdd2(0x170)](_0x5e5bbe);_0x39dd08=$dataWeapons[_0x3d379d],_0x1c2c44=_0x35fdd2(0x13f);}if(_0x2b9307['match'](/(?:SELL|SOLD) WEAPON[ ](.*):[ ](\d+)/i)){const _0x196868=String(RegExp['$1']);_0x4e9d3c=Number(RegExp['$2']);const _0xb4e708=/^\d+$/[_0x35fdd2(0x123)](_0x196868),_0x2a2eb6=_0xb4e708?Number(_0x196868):DataManager[_0x35fdd2(0x170)](_0x196868);_0x39dd08=$dataWeapons[_0x2a2eb6],_0x1c2c44=_0x35fdd2(0x13b);}if(_0x2b9307[_0x35fdd2(0x109)](/(?:BUY|BOUGHT) ARMOR[ ](.*):[ ](\d+)/i)){const _0x52a9dd=String(RegExp['$1']);_0x4e9d3c=Number(RegExp['$2']);const _0x258843=/^\d+$/[_0x35fdd2(0x123)](_0x52a9dd),_0x16fa51=_0x258843?Number(_0x52a9dd):DataManager[_0x35fdd2(0xfd)](_0x52a9dd);_0x39dd08=$dataArmors[_0x16fa51],_0x1c2c44=_0x35fdd2(0x13f);}if(_0x2b9307[_0x35fdd2(0x109)](/(?:SELL|SOLD) ARMOR[ ](.*):[ ](\d+)/i)){const _0x39b6cc=String(RegExp['$1']);_0x4e9d3c=Number(RegExp['$2']);const _0x4b8702=/^\d+$/['test'](_0x39b6cc),_0x4a4be1=_0x4b8702?Number(_0x39b6cc):DataManager[_0x35fdd2(0xfd)](_0x39b6cc);_0x39dd08=$dataArmors[_0x4a4be1],_0x1c2c44=_0x35fdd2(0x13b);}if(_0x39dd08){if(_0x39dd08===_0x35fdd2(0x167)){const _0xe6cd11=_0x1c2c44===_0x35fdd2(0x13f)?_0x2bfce1[_0x35fdd2(0x108)]:_0x2bfce1[_0x35fdd2(0x176)];_0x4f88ab=_0xe6cd11[_0x35fdd2(0xff)](TextManager[_0x35fdd2(0x16a)]);}else{const _0x42fe7c=_0x1c2c44==='buy'?_0x2bfce1[_0x35fdd2(0x101)]:_0x2bfce1[_0x35fdd2(0x124)],_0x3f1f69=_0x35fdd2(0x13c)[_0x35fdd2(0xff)](_0x39dd08['iconIndex']),_0x218ecd=_0x2bfce1[_0x35fdd2(0x10c)][_0x35fdd2(0xff)](_0x39dd08['name'],_0x3f1f69);_0x4f88ab=_0x42fe7c['format'](_0x218ecd);}const _0x3ea1c7=_0x2bfce1['numberDisplayFmt'];_0x4e9703=$gameParty[_0x35fdd2(0x165)](_0x1c2c44,_0x39dd08),_0x3b9c1a=_0x3ea1c7[_0x35fdd2(0xff)](_0x4e9703,_0x4e9d3c);if(_0x4e9703>=_0x4e9d3c){const _0x27d554=Window_ShopStatus['SHOP_LIST_UNLOCK'][_0x35fdd2(0x15d)];_0x3b9c1a=_0x35fdd2(0x17f)[_0x35fdd2(0xff)](_0x27d554,_0x3b9c1a);}const _0x2142d9=0x0,_0x155fe5=this[_0x35fdd2(0x119)],_0x19cf61=_0x4a7dcd;let _0x55f0e2=this[_0x35fdd2(0x120)]();this[_0x35fdd2(0xfe)](_0x4f88ab,_0x2142d9,_0x4a7dcd,_0x155fe5,!![],_0x35fdd2(0x15e)),this['shouldShopListingUnlockHaveExtraLine'](_0x4f88ab,_0x3b9c1a)&&(_0x4a7dcd+=this[_0x35fdd2(0x120)](),_0x55f0e2+=this['lineHeight']()),this[_0x35fdd2(0xfe)](_0x3b9c1a,_0x2142d9,_0x4a7dcd,_0x155fe5,![],_0x35fdd2(0x113)),this[_0x35fdd2(0x141)](_0x2142d9,_0x19cf61,_0x155fe5,_0x55f0e2),_0x4a7dcd+=this['lineHeight']();}return _0x4a7dcd;},Window_ShopStatus['prototype']['shouldShopListingUnlockHaveExtraLine']=function(_0x93e094,_0x1b88ee){const _0x3c4629=_0x1a5c44;this['_resetFontSize']=this[_0x3c4629(0x16d)]();const _0x1162d4=this[_0x3c4629(0x138)](_0x93e094)[_0x3c4629(0x114)],_0x1f7e3b=this['textSizeEx'](_0x1b88ee)['width'];this['_resetFontSize']=undefined;let _0x355794=this['innerWidth']-this['itemPadding']()*0x4;return _0x1162d4+_0x1f7e3b>=_0x355794;},Window_ShopStatus[_0x1a5c44(0x11d)][_0x1a5c44(0x10f)]=function(_0x87493){const _0x19756c=_0x1a5c44,_0x56f334=this[_0x19756c(0x126)]-_0x87493;this[_0x19756c(0x141)](0x0,_0x87493,this[_0x19756c(0x119)],_0x56f334,0x1);};